/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.list;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.internal.databinding.provisional.observable.AbstractObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.ObservableTracker;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IListChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiff;

public abstract class ObservableList
extends AbstractObservable
implements IObservableList {
    protected List wrappedList;
    private boolean stale = false;
    private Object listChangeListeners;
    private Object elementType;

    protected ObservableList(List wrappedList, Object elementType) {
        this.wrappedList = wrappedList;
        this.elementType = elementType;
    }

    public void addListChangeListener(IListChangeListener listener) {
        AbstractCollection listenerList;
        if (this.listChangeListeners == null) {
            boolean hadListeners = this.hasListeners();
            this.listChangeListeners = listener;
            if (!hadListeners) {
                this.firstListenerAdded();
            }
            return;
        }
        if (this.listChangeListeners instanceof Collection) {
            listenerList = (ArrayList<IListChangeListener>)this.listChangeListeners;
        } else {
            IListChangeListener l = (IListChangeListener)this.listChangeListeners;
            listenerList = new ArrayList<IListChangeListener>();
            listenerList.add(l);
            this.listChangeListeners = listenerList;
        }
        if (listenerList.size() > 16) {
            this.listChangeListeners = listenerList = new HashSet(listenerList);
        }
        listenerList.add(listener);
    }

    public void removeListChangeListener(IListChangeListener listener) {
        if (this.listChangeListeners == listener) {
            this.listChangeListeners = null;
            if (!this.hasListeners()) {
                this.lastListenerRemoved();
            }
            return;
        }
        if (this.listChangeListeners instanceof Collection) {
            Collection listenerList = (Collection)this.listChangeListeners;
            listenerList.remove(listener);
            if (listenerList.size() == 0) {
                this.listChangeListeners = null;
                if (!this.hasListeners()) {
                    this.lastListenerRemoved();
                }
            }
        }
    }

    protected boolean hasListeners() {
        return super.hasListeners() || this.listChangeListeners != null;
    }

    protected void fireListChange(ListDiff diff) {
        super.fireChange();
        if (this.listChangeListeners == null) {
            return;
        }
        if (this.listChangeListeners instanceof IListChangeListener) {
            ((IListChangeListener)this.listChangeListeners).handleListChange(this, diff);
            return;
        }
        Collection changeListenerCollection = (Collection)this.listChangeListeners;
        IListChangeListener[] listeners = changeListenerCollection.toArray(new IListChangeListener[changeListenerCollection.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].handleListChange(this, diff);
            ++i;
        }
    }

    public boolean contains(Object o) {
        this.getterCalled();
        return this.wrappedList.contains(o);
    }

    public boolean containsAll(Collection c) {
        this.getterCalled();
        return this.wrappedList.containsAll(c);
    }

    public boolean equals(Object o) {
        this.getterCalled();
        return this.wrappedList.equals(o);
    }

    public int hashCode() {
        this.getterCalled();
        return this.wrappedList.hashCode();
    }

    public boolean isEmpty() {
        this.getterCalled();
        return this.wrappedList.isEmpty();
    }

    public Iterator iterator() {
        final Iterator wrappedIterator = this.wrappedList.iterator();
        return new Iterator(){

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                ObservableTracker.getterCalled(ObservableList.this);
                return wrappedIterator.hasNext();
            }

            public Object next() {
                ObservableTracker.getterCalled(ObservableList.this);
                return wrappedIterator.next();
            }
        };
    }

    public int size() {
        this.getterCalled();
        return this.wrappedList.size();
    }

    public Object[] toArray() {
        this.getterCalled();
        return this.wrappedList.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.getterCalled();
        return this.wrappedList.toArray(a);
    }

    public String toString() {
        this.getterCalled();
        return this.wrappedList.toString();
    }

    public Object get(int index) {
        this.getterCalled();
        return this.wrappedList.get(index);
    }

    public int indexOf(Object o) {
        this.getterCalled();
        return this.wrappedList.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        this.getterCalled();
        return this.wrappedList.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        final ListIterator wrappedIterator = this.wrappedList.listIterator(index);
        return new ListIterator(){

            public int nextIndex() {
                ObservableList.this.getterCalled();
                return wrappedIterator.nextIndex();
            }

            public int previousIndex() {
                ObservableList.this.getterCalled();
                return wrappedIterator.previousIndex();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                ObservableList.this.getterCalled();
                return wrappedIterator.hasNext();
            }

            public boolean hasPrevious() {
                ObservableList.this.getterCalled();
                return wrappedIterator.hasPrevious();
            }

            public Object next() {
                ObservableList.this.getterCalled();
                return wrappedIterator.next();
            }

            public Object previous() {
                ObservableList.this.getterCalled();
                return wrappedIterator.previous();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        this.getterCalled();
        return this.wrappedList.subList(fromIndex, toIndex);
    }

    protected void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean isStale() {
        return this.stale;
    }

    public void setStale(boolean stale) {
        boolean wasStale = this.stale;
        this.stale = stale;
        if (!wasStale && stale) {
            this.fireStale();
        }
    }

    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireListChange() instead");
    }

    public void dispose() {
        this.listChangeListeners = null;
        super.dispose();
    }

    public Object getElementType() {
        return this.elementType;
    }

    protected void updateWrappedList(List newList) {
        List oldList = this.wrappedList;
        ListDiff listDiff = Diffs.computeListDiff(oldList, newList);
        this.wrappedList = newList;
        this.fireListChange(listDiff);
    }
}

